############################################################################
## Prepare a perl script for being run from a network share               ##
## or an UNC path. If you have the path \\server\share\perl\bin\perl.exe  ##
## the specified path should be "-s \\server\share\perl".                 ##
## If it's on a mapped drive, it would be "-s X:\somedir\perl"            ##
############################################################################

## Author: Joakim Svendsen
## Last revision: 2011-05-22
## Mail: svendsentech@gmail.com

use warnings;
use strict;
use Getopt::Std;
use File::Basename;

my %opt;

getopts('f:s:o:', \%opt);

unless ($opt{f} && $opt{s} && $opt{o}) {
    
    my $script_name = basename $0;
    
    print <<EOF;
Usage:
$script_name -f "file.pl" -s "\\\\server\\share\\perl"
-o "outputfile.cmd"

-f : .pl file to convert to .cmd
-s : Server and share where Perl should be run from. Should be the
     Perl root directory as "\\bin\\perl.exe" will be appended.
-o : Output file name. You will be asked to overwrite if it exists.

Examples:
$script_name -f "get_files.pl" -s "\\\\server.domain.com\\perl" -o "test.bat"
$script_name -f "do_stuff.pl" -s "\\\\dev-server\\perl" -o "T:\\do_stuff.cmd"

You don't need to quote arguments unless they contain spaces.
You can use either the .bat or the .cmd extension. The cmd extension allows
for more advanced batch features, but does not run on NT4/Win98. None of
these batch features are being used, so use whatever you prefer, with a
note that .bat is more backwards compatible.

Author: Joakim Svendsen, Svendsen Tech, www.svendsentech.no
EOF
    
    exit;
    
}

# Populate friendly-named variables
my $file        = $opt{f};
my $share       = $opt{s};
my $output_file = $opt{o};

open my $fh, '<', $file or die "Unable to open $file: $!\n$^E";

# Just slurp the file into an array
my @file = <$fh>;

# Close the file handle
close($fh);

# Be polite and ask before clobbering an existing file
if (-e $output_file) {
    
    print "$output_file already exists. Overwrite? (y/n) [yes] : ";
    chomp(my $answer = <STDIN>);
    die "Aborted.\n" if $answer =~ /^n/;
    
}

open $fh, '>', $output_file or die "Unable to create output file $output_file: $!\n$^E";

print $fh q(@rem = \'-- Batch wrapper created with Svendsen Tech Perl2Cmd --), "\n";
print $fh '@echo off', "\n";
print $fh "$share\\bin\\perl.exe %0 %1 %2 %3 %4 %5 %6 %7 %8 %9", "\n\n";
print $fh 'goto endofperl', "\n\n";
print $fh '@rem \';', "\n\n";

print $fh @file;

print $fh "\n\n__END__\n:endofperl\n";

close($fh);

print "Done! Output file for use with $share: $output_file\n";