#
# Module manifest for module 'PSGET_SSHSessions'
#
# Generated by: Joakim Borger Svendsen
#
# Generated on: 12/30/2017
# v1.9 - Add -Reconnect to New-SshSession. Standardize output more to Ansible style.
# Some breaking changes if output is parsed, due to this.
# v1.9.1 - Add -ScriptBlock to Invoke-SshCommand.
# v1.9.2 - Bug fixes and improvements. Vastly improved pipeline handling.
# v2.0 - Emit objects instead of strings. Majorly breaking change, but
#        I think it's needed and much better. Have been considering switching
#        to Write-Verbose for a lot of the output and have it quiet, as is
#        the convention, but I imagine that after 6 years in the wild, there are
#        thousands of meta scripts using this module - and some might be parsing
#        the output to determine success. I will look into redesigning and
#        standardizing further. Pushing this for now.
# v2.1 - Standardize completely to Write-Warning, Write-Error and Write-Verbose.
#        Possibly another, recent breaking change.
# v2.1.1 - Fix a bug that caused the calling scripts to terminate when
#        Get-SshSession and Remove-SshSession -RemoveAll were called (tested on PS v5.1).
#        Worked around.

@{

# Script module or binary module file associated with this manifest.
RootModule = 'SSHSessions.psm1'

# Version number of this module.
ModuleVersion = '2.1.1'

# Supported PSEditions
# CompatiblePSEditions = @()

# ID used to uniquely identify this module
GUID = '65be3f86-9eda-469a-9b2f-2cca1840bbf6'

# Author of this module
Author = 'Joakim Borger Svendsen'

# Company or vendor of this module
CompanyName = 'Svendsen Tech'

# Copyright statement for this module
Copyright = 'Copyright (c) 2012-2018, Joakim Borger Svendsen, Svendsen Tech. All rights reserved.'

# Description of the functionality provided by this module
Description = 'Svendsen Tech''s SSH-Sessions module provides SSH session creation, management and interaction from PowerShell. Lets you execute commands via SSH against Linux and certain network equipment, etc. MIT license. Online documentation here: https://www.powershelladmin.com/wiki/SSH_from_PowerShell_using_the_SSH.NET_library'

# Minimum version of the Windows PowerShell engine required by this module
PowerShellVersion = '3.0'

# Name of the Windows PowerShell host required by this module
# PowerShellHostName = ''

# Minimum version of the Windows PowerShell host required by this module
# PowerShellHostVersion = ''

# Minimum version of Microsoft .NET Framework required by this module. This prerequisite is valid for the PowerShell Desktop edition only.
DotNetFrameworkVersion = '4.0'

# Minimum version of the common language runtime (CLR) required by this module. This prerequisite is valid for the PowerShell Desktop edition only.
# CLRVersion = ''

# Processor architecture (None, X86, Amd64) required by this module
# ProcessorArchitecture = ''

# Modules that must be imported into the global environment prior to importing this module
# RequiredModules = @()

# Assemblies that must be loaded prior to importing this module
RequiredAssemblies = 'Renci.SshNet.dll'

# Script files (.ps1) that are run in the caller's environment prior to importing this module.
# ScriptsToProcess = @()

# Type files (.ps1xml) to be loaded when importing this module
# TypesToProcess = @()

# Format files (.ps1xml) to be loaded when importing this module
# FormatsToProcess = @()

# Modules to import as nested modules of the module specified in RootModule/ModuleToProcess
# NestedModules = @()

# Functions to export from this module, for best performance, do not use wildcards and do not delete the entry, use an empty array if there are no functions to export.
FunctionsToExport = 'New-SshSession', 'Invoke-SshCommand', 'Enter-SshSession', 
               'Remove-SshSession', 'Get-SshSession', 'ConvertFrom-SecureToPlain'

# Cmdlets to export from this module, for best performance, do not use wildcards and do not delete the entry, use an empty array if there are no cmdlets to export.
CmdletsToExport = @()

# Variables to export from this module
# VariablesToExport = @()

# Aliases to export from this module, for best performance, do not use wildcards and do not delete the entry, use an empty array if there are no aliases to export.
AliasesToExport = @()

# DSC resources to export from this module
# DscResourcesToExport = @()

# List of all modules packaged with this module
# ModuleList = @()

# List of all files packaged with this module
FileList = @('Renci.SshNet.dll', 'SSHSessions.psm1', 'SSHSessions.psd1', 'SSHSessions.Tests.ps1')

# Private data to pass to the module specified in RootModule/ModuleToProcess. This may also contain a PSData hashtable with additional module metadata used by PowerShell.
PrivateData = @{

    PSData = @{

        # Tags applied to this module. These help with module discovery in online galleries.
        Tags = @('SSH', 'Linux', 'Unix', 'Cisco', 'Networking')

        # A URL to the license for this module.
        # LicenseUri = ''

        # A URL to the main website for this project.
        # ProjectUri = ''

        # A URL to an icon representing this module.
        # IconUri = ''

        # ReleaseNotes of this module
        ReleaseNotes = '# v2.1.1 - Fix a bug that caused the calling scripts to terminate when
# Get-SshSession and Remove-SshSession -RemoveAll were called (tested on PS v5.1). Worked around.'

        # External dependent modules of this module
        # ExternalModuleDependencies = ''

    } # End of PSData hashtable

} # End of PrivateData hashtable

# HelpInfo URI of this module
# HelpInfoURI = ''

# Default prefix for commands exported from this module. Override the default prefix using Import-Module -Prefix.
# DefaultCommandPrefix = ''

}

